<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowMainPage()
  ===================================================*/

  function ShowMainPage() {
    global $dbConn,$admin_template_path, $category_separator;
    global $active_links, $active_categories, $active_reviews, $active_users,
             $await_links, $await_reviews, $suspended_links, $bad_links, 
             $mailing_list_subscribers, $whosonline_listing, 
             $top_categories_by_hits, $top_categories_by_rating, 
             $top_categories_by_votes;
    
    $query = "select count(category_id) as active_categories from idx_category";
    $result = $dbConn->Execute($query);
    $active_categories = $result->Fields("active_categories");

    $query = "select count(link_id) as active_links from idx_link";
    $result = $dbConn->Execute($query);
    $active_links = $result->Fields('active_links');

    $query = "select count(review_id) as active_reviews from idx_review";
    $result = $dbConn->Execute($query);
    $active_reviews = $result->Fields('active_reviews');

    $query = "select count(review_id) as await_reviews from idx_review where status=0";
    $result = $dbConn->Execute($query);
    $await_reviews = $result->Fields('await_reviews');

    $query = "select count(vid) as await_links from idx_link_temp";
    $result = $dbConn->Execute($query);
    $await_links = $result->Fields('await_links');
    
    $query = "select count(bad_link_id) as bad_links from idx_bad_link";
    $result = $dbConn->Execute($query);
    $bad_links = $result->Fields('bad_links');

    $query = "select count(email) as mailing_list_subscribers from idx_mailing_list where status = 1";
    $result = $dbConn->Execute($query);
    $mailing_list_subscribers = $result->Fields('mailing_list_subscribers');

    $query = "select count(username) as username from idx_users where status=1";
    $result = $dbConn->Execute($query);
    $active_users = $result->Fields('username');

    $query = "select count(link_id) as suspended_links from idx_link where suspended = 1";
    $result = $dbConn->Execute($query);
    $suspended_links = $result->Fields('suspended_links');

    //print "$bad_links - $active_reviews";
    global $act_review, $bad_link;

    $act_review = $active_reviews;
    $bad_link = $bad_links;	
    
    
    // who's online
    
    global $whosonline,$username,$ip,$location,$expiry,$tbl_class,
      $members_online, $total_online, $guest_online;
    
    if(!empty($whosonline)) $exp = $whosonline;
    else $exp = 600;
    
    $expired = time() - $exp;
    
    // get total users online
    
    $query = "select data, expiry from idx_sessions where expiry > $expired
              order by expiry desc";
    $result = $dbConn->Execute($query);
    
    $i = 0;
    $ip_arr = array();
    while(!$result->EOF) {
      $data = $result->Fields(data);
      $data = urldecode($data);

      // parse session data
      $data = substr($data,0,strlen($data)-1);  
      $str = explode(";",$data);
      $dump = array();
      
      foreach($str as $key => $val) {
        $str1 = explode("|",$val);
        foreach($str1 as $key1 => $val1) {
          if(preg_match("/s:/i",$val1)) $dump[$vkey] = unserialize($val1);
          else $vkey = $val1;
        } 
      } 
    
      if (!in_array($dump[indexu_session_ip], $ip_arr)) {
        $ip_arr[] = $dump[indexu_session_ip];
        $ip = $dump[indexu_session_ip];
        $location = $dump[indexu_session_location];
        $username = $dump[indexu_session_username];
        if(empty($username)) {
          $guest_online++;
          $username = "guest";
        }
        else {
          $members_online++;
          $username = "<a href=user_edit.php?username=$username>$username</a>";
        }
        
        $expiry = date("d.m.Y H:i",$result->Fields(expiry));		
        
        if($i%2) $tbl_class = "tbl_light";
        else $tbl_class = "tbl_light2";
        
        if ($i <= 5) {
          $whosonline_listing .= EvalTemplate($admin_template_path . "whos_rows.html",
          "\$ip,\$location,\$username,\$expiry,\$tbl_class");
        }
        
        $total_online++;
        $i++;
      }

      $result->MoveNext();
    }
    

    // top categories
    
    $category_obj = new clsCategory;

    $category_obj->table_name = "idx_category";
    $category_obj->separator = $category_separator; 
    
    $query = "select category_id, hits from idx_category where hits > 0 order by hits desc";
    $result = $dbConn->Execute($query);
    
    $number = $i = 0;
    while(!$result->EOF && $i<5) {
      $cid = $result->Fields("category_id");
      $hits = $result->Fields("hits");
      
      $cat_name = $category_obj->GetCategoryPath($cid);

      if($i%2) $tbl_class = "tbl_light";
      else $tbl_class = "tbl_light2";
      
      $number++;
    
      $top_categories_by_hits .= "
        <tr class=$tbl_class>
          <td align=left width=15>$number.</td>
          <td align=left>$cat_name</td>
          <td align=right>$hits</td>
        </tr>
      ";
      $i++;
      $result->MoveNext();
    }
    
    $query = "select link_id, title, rating, url from idx_link where rating > 0 order by rating desc";
    $result = $dbConn->Execute($query);
    
    $number = $i = 0;
    while(!$result->EOF && $i<5) {
      $lid = $result->Fields("link_id");
      $rating = $result->Fields("rating");
      $title = $result->Fields("title");
      $url = $result->Fields("url");
      
      if($i%2) $tbl_class = "tbl_light";
      else $tbl_class = "tbl_light2";
      
      $number++;
      
      $top_categories_by_rating .= "
        <tr class=$tbl_class>
          <td align=left width=15>$number.</td>
          <td align=left><a href=$url>$title</a></td>
          <td align=right>$rating</td>
        </tr>
      ";
      $i++;
      $result->MoveNext();
    }

    $query = "select link_id, title, votes, url from idx_link where votes > 0 order by votes desc";
    $result = $dbConn->Execute($query);
    
    $number = $i = 0;
    while(!$result->EOF && $i<5) {
      $lid = $result->Fields("link_id");
      $votes = $result->Fields("votes");
      $title = $result->Fields("title");
      $url = $result->Fields("url");

      if($i%2) $tbl_class = "tbl_light";
      else $tbl_class = "tbl_light2";
      
      $number++;
      
      $top_categories_by_votes .= "
        <tr class=$tbl_class>
          <td align=left width=15>$number.</td>
          <td align=left><a href=$url>$title</a></td>
          <td align=right>$votes</td>
        </tr>
      ";
      $i++;
      $result->MoveNext();
    }
    
    DisplayTemplate($admin_template_path . "summary.html",
      "\$active_links,\$active_categories,\$no_var,\$await_links,".
      "\$await_reviews,\$no_var2,\$mailing_list_subscribers,\$active_users,".
      "\$bad_link,\$act_review,\$whosonline_listing,\$members_online,".
      "\$total_online,\$guest_online,\$top_categories_by_hits,".
      "\$top_categories_by_rating,\$top_categories_by_votes,\$suspended_links");
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";

  RunPreFilter(__FILE__);

  DisplayTemplate($admin_template_path . "header.html");
  ShowMainPage();
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>